package main;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import net.miginfocom.swing.MigLayout;
import util.Utility;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JButton;
import javax.swing.JTextArea;
import java.awt.Dimension;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;

public class GUI {

	private JFrame frmSgtPepper;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel eastPanel;
	private JPanel southPanel;
	private JPanel centralPanel;
	private JLabel lblAlbum;
	private JLabel lblTitle;
	private JTextField titleTextField;
	private JLabel lblPerformer;
	private JTextField performerTextField;
	private JLabel lblSongs;
	private JComboBox songsComboBox;
	private JLabel lblReleaseDate;
	private JLabel lblSpecificRelesaDate;
	private JLabel lblCredits;
	private JTextArea creditsTextArea;
	private JButton btnSave;
	private JSplitPane splitPane;
	private JScrollPane leftScrollPane;
	private JScrollPane rightScrollPane;
	private JTextArea lyricsTextArea;
	private JLabel lblPicture;
	private JRadioButton rdbtnBasic;
	private JRadioButton rdbtnStandard;
	private JRadioButton rdbtnAll;
	private JLabel lblDetails;
	private final ButtonGroup buttonGroup = new ButtonGroup();

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUI window = new GUI();
					window.frmSgtPepper.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public GUI() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmSgtPepper = new JFrame();
		createResourcesDir();
		frmSgtPepper.setTitle("Sgt. Pepper");
		frmSgtPepper.setBounds(100, 100, 579, 428);
		frmSgtPepper.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmSgtPepper.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmSgtPepper.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmSgtPepper.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmSgtPepper.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmSgtPepper.getContentPane().add(getCentralPanel(), BorderLayout.CENTER);
	}
	
	private void createResourcesDir() {
//		System.out.println(Utility.getSubdir("resources"));
		Utility.getSubdir("resources");
	}

	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			northPanel.add(getLblAlbum());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setLayout(new MigLayout("", "[grow]", "[][][][][][]"));
			westPanel.add(getLblTitle(), "cell 0 0");
			westPanel.add(getTitleTextField(), "cell 0 1,growx");
			westPanel.add(getLblPerformer(), "cell 0 2");
			westPanel.add(getPerformerTextField(), "cell 0 3,growx");
			westPanel.add(getLblSongs(), "cell 0 4");
			westPanel.add(getSongsComboBox(), "cell 0 5,growx");
		}
		return westPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setPreferredSize(new Dimension(130, 10));
			eastPanel.setLayout(new MigLayout("", "[grow]", "[][][][grow][]"));
			eastPanel.add(getLblReleaseDate(), "cell 0 0");
			eastPanel.add(getLblSpecificRelesaDate(), "cell 0 1");
			eastPanel.add(getLblCredits(), "cell 0 2");
			eastPanel.add(getCreditsTextArea(), "cell 0 3,grow");
			eastPanel.add(getBtnSave(), "cell 0 4,alignx right");
		}
		return eastPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[grow][][][][grow]", "[][]"));
			southPanel.add(getLblDetails(), "cell 1 0 3 1,alignx center");
			southPanel.add(getRdbtnBasic(), "cell 1 1");
			southPanel.add(getRdbtnStandard(), "cell 2 1");
			southPanel.add(getRdbtnAll(), "cell 3 1");
		}
		return southPanel;
	}
	private JPanel getCentralPanel() {
		if (centralPanel == null) {
			centralPanel = new JPanel();
			centralPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
			centralPanel.add(getSplitPane(), "cell 0 0,grow");
		}
		return centralPanel;
	}
	private JLabel getLblAlbum() {
		if (lblAlbum == null) {
			lblAlbum = new JLabel("Album");
		}
		return lblAlbum;
	}
	private JLabel getLblTitle() {
		if (lblTitle == null) {
			lblTitle = new JLabel("Title");
		}
		return lblTitle;
	}
	private JTextField getTitleTextField() {
		if (titleTextField == null) {
			titleTextField = new JTextField();
			titleTextField.setColumns(10);
		}
		return titleTextField;
	}
	private JLabel getLblPerformer() {
		if (lblPerformer == null) {
			lblPerformer = new JLabel("Performer");
		}
		return lblPerformer;
	}
	private JTextField getPerformerTextField() {
		if (performerTextField == null) {
			performerTextField = new JTextField();
			performerTextField.setColumns(10);
		}
		return performerTextField;
	}
	private JLabel getLblSongs() {
		if (lblSongs == null) {
			lblSongs = new JLabel("Songs");
		}
		return lblSongs;
	}
	private JComboBox getSongsComboBox() {
		if (songsComboBox == null) {
			songsComboBox = new JComboBox();
		}
		return songsComboBox;
	}
	private JLabel getLblReleaseDate() {
		if (lblReleaseDate == null) {
			lblReleaseDate = new JLabel("Release date");
		}
		return lblReleaseDate;
	}
	private JLabel getLblSpecificRelesaDate() {
		if (lblSpecificRelesaDate == null) {
			lblSpecificRelesaDate = new JLabel("");
		}
		return lblSpecificRelesaDate;
	}
	private JLabel getLblCredits() {
		if (lblCredits == null) {
			lblCredits = new JLabel("Credits");
		}
		return lblCredits;
	}
	private JTextArea getCreditsTextArea() {
		if (creditsTextArea == null) {
			creditsTextArea = new JTextArea();
		}
		return creditsTextArea;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					
				}
			});
		}
		return btnSave;
	}
	private JSplitPane getSplitPane() {
		if (splitPane == null) {
			splitPane = new JSplitPane();
			splitPane.setLeftComponent(getLeftScrollPane());
			splitPane.setRightComponent(getRightScrollPane());
		}
		return splitPane;
	}
	private JScrollPane getLeftScrollPane() {
		if (leftScrollPane == null) {
			leftScrollPane = new JScrollPane();
			leftScrollPane.setViewportView(getLyricsTextArea());
		}
		return leftScrollPane;
	}
	private JScrollPane getRightScrollPane() {
		if (rightScrollPane == null) {
			rightScrollPane = new JScrollPane();
			rightScrollPane.setViewportView(getLblPicture());
		}
		return rightScrollPane;
	}
	private JTextArea getLyricsTextArea() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
		}
		return lyricsTextArea;
	}
	private JLabel getLblPicture() {
		if (lblPicture == null) {
			lblPicture = new JLabel("");
			lblPicture.setHorizontalAlignment(SwingConstants.CENTER);
			lblPicture.setIcon(new ImageIcon("C:\\Users\\student1\\Desktop\\Eclipse workspace\\Sgt. Pepper\\resources\\sgt.jpg"));
		}
		return lblPicture;
	}
	private JRadioButton getRdbtnBasic() {
		if (rdbtnBasic == null) {
			rdbtnBasic = new JRadioButton("Basic");
			buttonGroup.add(rdbtnBasic);
		}
		return rdbtnBasic;
	}
	private JRadioButton getRdbtnStandard() {
		if (rdbtnStandard == null) {
			rdbtnStandard = new JRadioButton("Standard");
			buttonGroup.add(rdbtnStandard);
			rdbtnStandard.setSelected(true);
		}
		return rdbtnStandard;
	}
	private JRadioButton getRdbtnAll() {
		if (rdbtnAll == null) {
			rdbtnAll = new JRadioButton("All");
			buttonGroup.add(rdbtnAll);
		}
		return rdbtnAll;
	}
	private JLabel getLblDetails() {
		if (lblDetails == null) {
			lblDetails = new JLabel("Details");
		}
		return lblDetails;
	}
}
